﻿//////////////////////////////////////////////
// MeshManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Mesh ;
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Mesh.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <mutex>
#include <string>
#include <unordered_map>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT MeshManager final : public Manager<Mesh>, public nkCommon::MaybeSingletonClass<MeshManager>
	{			
		public :

			inline static const nkMemory::StringView POST_PROCESSING_MESH = "NILKINS_POSTPROCESS_SQUARE" ;

		private :

			// Constructors
			MeshManager (bool isSingleton) noexcept ;
			MeshManager (System* system) noexcept ;

			// Customization
			virtual void _setupResource (Mesh* resource) override ;

		private :
		
			// Attributes
			unsigned int _idCounter ;

		private :

			friend class nkCommon::MaybeSingletonClass<MeshManager> ;
			friend class System ;
	} ;
}